/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.block.plants;

import azmalent.terraincognita.common.registry.ModBlocks;
import azmalent.terraincognita.common.world.feature.CaribouMossFeature;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CaribouMossWallBlock
extends Block
implements IGrowable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)0.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)11.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)5.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (Object)Direction.EAST, (Object)Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)16.0)));

    public CaribouMossWallBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150349_c));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING});
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES.get(state.func_177229_b((Property)FACING));
    }

    @Nonnull
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nonnull
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockPos offset = pos.func_177972_a(direction.func_176734_d());
        return worldIn.func_180495_p(offset).func_224755_d((IBlockReader)worldIn, offset, direction);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        for (Direction direction : context.func_196009_e()) {
            BlockState state;
            if (!direction.func_176740_k().func_176722_c() || !(state = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction.func_176734_d())).func_196955_c((IWorldReader)world, pos)) continue;
            return state;
        }
        return null;
    }

    @Nonnull
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing.func_176734_d() == stateIn.func_177229_b((Property)FACING) && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nonnull
    public List<ItemStack> func_220076_a(@Nonnull BlockState state, @Nonnull LootContext.Builder builder) {
        return ModBlocks.CARIBOU_MOSS.getBlock().func_176223_P().func_215693_a(builder);
    }

    @Nonnull
    public String func_149739_a() {
        return ModBlocks.CARIBOU_MOSS.getBlock().func_149739_a();
    }

    public boolean func_176473_a(@Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return true;
    }

    public void func_225535_a_(@Nonnull ServerWorld worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        for (int i = 0; i < 3; ++i) {
            BlockPos nextPos;
            int x = rand.nextInt(3) - rand.nextInt(3);
            int y = rand.nextInt(2) - rand.nextInt(2);
            int z = rand.nextInt(3) - rand.nextInt(3);
            if (x == 0 && z == 0 || !worldIn.func_175623_d(nextPos = pos.func_177982_a(x, y, z)) && !worldIn.func_180495_p(nextPos).func_203425_a(Blocks.field_150433_aE)) continue;
            CaribouMossFeature.tryPlaceMoss((ISeedReader)worldIn, pos.func_177982_a(x, y, z), rand);
        }
    }
}

